const enabledSites = [
  "youtube.com/watch",
  "music.youtube.com/watch",
  "soundcloud.com/"
];

// Update icon and title when tab URL changes
chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (!tab.url) return;

  const isSupported = enabledSites.some(site => tab.url.includes(site));

  chrome.action.setIcon({
    tabId,
    path: isSupported ? {
      16: "icon16.png",
      48: "icon48.png",
      128: "icon128.png"
    } : {
      16: "icon-gray16.png",
      48: "icon-gray48.png",
      128: "icon-gray128.png"
    }
  });

  chrome.action.setTitle({
    tabId,
    title: isSupported
      ? "Send to Kaizo (opens in new tab)"
      : "Only works on YouTube, YouTube Music, or SoundCloud"
  });
});

// On icon click, open Kaizo in a new tab (don’t redirect current)
chrome.action.onClicked.addListener((tab) => {
  if (!tab.url) return;

  const isSupported = enabledSites.some(site => tab.url.includes(site));

  if (isSupported) {
    chrome.tabs.create({
      url: "https://kaizo.cc/index.php?v=" + encodeURIComponent(tab.url)
    });
  }
});
